
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_Ext_ATP_Data.c#1:csrc:1
   *  \author tania
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/

#include "SST_Ext_ATP_Data.h"
#include "SST_Ext_ATP_DataTstVectors.h"
#include "MW_ATP_UTIL_funcs.h"
#include "ExtApp_HOST_TST_Message.h"
#include "NVS.h"
#include "SST_EXT_TST.h"

extern DxError_t      EXT_TST_ATP_Error;
extern DxError_t      EXT_TST_TestStatus;

#if TST_USE_DATA_MODULE

/************************ Public Functions *********************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_BasicDataOp         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the creation, deletion, modification, opening, closing and usage of a password authenticator object. 
 * And demonstrate the use of transaction with authenticator objects
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 ********************************************************************************/    
DxError_t SST_Ext_ATP_BasicDataOp ( void )
{
    /********* TST Variables Definitions ************/
    int                         TST_index = 0;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_BasicDataOp";
    
    /********* TST Variables initialization *********/
     EXT_TST_TestStatus = TESTPASS;
    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
   

    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",SEP_ATP_DataOpTestData[TST_index].TST_Name,"\n")); 
            
    EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_BasicDataOp_OP_CODE,sizeof(Ext_ATP_DataOpTestDataStruct),SEP_ATP_DataOpTestData);

	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"HOSTQA_ATP_BasicDataOp", 
											      "SST_Ext_ATP_BasicDataOp",TST_MasterTestName); 
    return EXT_TST_TestStatus;
    
}/* End of SST_Ext_ATP_BasicDataOp */

/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_BasicUnAuthnticatedDataOp       
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the insertion, deletion, modification, opening, getting data size for a data object using default internal authenticator.
 * And demonstration on the use of transaction with data objects
 *
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 
 
 DxError_t SST_Ext_ATP_BasicUnAuthnticatedDataOp(  )
 {
 	 
    /********* TST Variables Definitions ************/
    int                         TST_index = 0;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_BasicDataOp";
    /********* TST Variables initialization *********/
     EXT_TST_TestStatus = TESTPASS;
    
    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
   
   
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",SEP_ATP_DataOpTestData[TST_index].TST_Name,"\n")); 
            
											    
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"HOSTQA_ATP_BasicDataOp", 
											      "SST_Ext_ATP_BasicDataOp",TST_MasterTestName); 
    return EXT_TST_TestStatus;

		  												                        
 }/* End of SST_Ext_ATP_BasicUnAuthnticatedDataOp */
 /*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_BindingWritingPermissions       
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the bind and unbind authenticator to data object capabilities of the SST
 * NOTE: this is a test that has error return values as a correct matter or operation!
 *
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 
   
DxError_t SST_Ext_ATP_BindingWritingPermissions ( void )
{
    /********* TST Variables Definitions ************/
    int                                TST_index = 0;
    char                               TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_BindingWritingPermissions";
   
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;
   
    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
     
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",SEP_ATP_BindingWritingPermissionsTestData[TST_index].TST_Name,"\n")); 
   
    EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_BindingWritingPermissions_OP_CODE,
                                           sizeof(Ext_ATP_BindingWritingPermissionsStruct),
                                           SEP_ATP_BindingWritingPermissionsTestData);
																						    
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"HOSTQA_ATP_BindingWritingPermissions", 
											      "SST_Ext_ATP_BindingWritingPermissions",TST_MasterTestName); 
    return EXT_TST_TestStatus;
    
}/* SST_Ext_ATP_BindingWritingPermissions */

/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_DataReplace       
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test data replace operation
 *
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
 
   
DxError_t SST_Ext_ATP_DataReplace ( void )
{

    /********* TST Variables Definitions ************/
     char                               TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_DataReplace";
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
       
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_MasterTestName,"\n")); 
     
    EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_DataReplace_OP_CODE,DX_NULL,DX_NULL);

	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"HOSTQA_ATP_DataReplace", 
											      "SST_Ext_ATP_DataReplace",TST_MasterTestName);
											      
    return EXT_TST_TestStatus;
    
}/* SST_Ext_ATP_DataReplace */

/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ReadOnlyData       
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *     Test data replace operation
 *
 * Algorithm:       
 *    1.Call to  SST_Terminate. 
 *    2.Call to  SST_Init.
 *    3.Call to  HOSTQA_ATP_Message function
 *    4.Call to  SST_Terminate. 
 *    5.Call to  SST_Init.
 *******************************************************************************/ 
  
DxError_t SST_Ext_ReadOnlyData ( void )
{

    /********* TST Variables Definitions ************/
    char                               TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_ReadOnlyData";
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;
   
    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_MasterTestName,"\n"));
    
    /*Terminate SST*/
    EXT_TST_ATP_Error = SST_Terminate();   											    
  
    EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Terminate", 
											      "SST_Ext_ATP_ReadOnlyData",TST_MasterTestName); 
  
    if (EXT_TST_TestStatus!=TST_PASS) 
   	goto EXIT;
    /*Initalize SST*/
    EXT_TST_ATP_Error= SST_Init((DxNvsMemoryId_t)TST_Ext_MainDBFileHandle,
                                (DxNvsMemoryId_t)TST_Ext_SecondaryDBFileHandle,
                                 DX_NULL,
                                 TST_Ext_Workspace,
                                 TST_Ext_WorkspaceSizeInBytes);                           
   
   	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Init", 
											      "SST_Ext_ATP_ReadOnlyData",TST_MasterTestName); 
                          
    if (EXT_TST_TestStatus!=TST_PASS) 
   	goto EXIT;
   
    /*Call to  HOSTQA_ATP_Message*/
    EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_SST_ReadOnlyData_OP_CODE,sizeof(Ext_ATP_DataOpTestDataStruct),SEP_ATP_DataOpTestData);
   
   	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"HOSTQA_ATP_ReadOnlyData", 
											      "SST_Ext_ATP_ReadOnlyData",TST_MasterTestName); 
  
    if (EXT_TST_TestStatus!=TST_PASS) 
   	goto EXIT;

	/*Terminate SST*/	
	EXT_TST_ATP_Error = SST_Terminate(); 

	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Terminate", 
											      "SST_Ext_ATP_ReadOnlyData",TST_MasterTestName); 
 
   if (EXT_TST_TestStatus!=TST_PASS) 
   	goto EXIT;
   
    /* Close and delete the database */
    /*------------------------------------*/
    /* Close the file*/
#ifndef DX_NVS_RAM
  EXT_TST_ATP_Error = DX_VOS_FClose(TST_Ext_MainDBFileHandle);
  
  EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"DX_VOS_FClose", 
											      "SST_Ext_ATP_ReadOnlyData",TST_MasterTestName); 

 if (EXT_TST_TestStatus!=TST_PASS) 
   	goto EXIT; 
#endif

    /* Delete the file */
#ifndef DX_NVS_RAM
  EXT_TST_ATP_Error = DX_VOS_FDelete(SST_DB_FILENAME);

  EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"DX_VOS_FDelete", 
											      "SST_Ext_ATP_ReadOnlyData",TST_MasterTestName); 
 
 if (EXT_TST_TestStatus!=TST_PASS) 
   	goto EXIT; 
#endif

#ifdef DX_NVS_RAM

         DX_VOS_MemSetZero(TST_Ext_MainDBPool,NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES);
         DX_VOS_MemSetZero(TST_Ext_SecondaryDBPool,NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES);
         
#endif

    /* reopen the file for the tests to continue */
#ifndef DX_NVS_RAM
  EXT_TST_ATP_Error = DX_VOS_FOpen(&TST_Ext_MainDBFileHandle,SST_DB_FILENAME ,"w+b");
  
  EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"DX_VOS_FOpen", 
											      "SST_Ext_ATP_ReadOnlyData",TST_MasterTestName); 
 
   if (EXT_TST_TestStatus!=TST_PASS) 
   	goto EXIT; 

#endif
   
   /*Initalize SST*/
    EXT_TST_ATP_Error= SST_Init((DxNvsMemoryId_t)TST_Ext_MainDBFileHandle,
                                 (DxNvsMemoryId_t)TST_Ext_SecondaryDBFileHandle,
                                  DX_NULL,
                                  TST_Ext_Workspace,
                                  TST_Ext_WorkspaceSizeInBytes);
                                 
   EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Init", 
											      "SST_Ext_ATP_ReadOnlyData",TST_MasterTestName); 
    	
   if (EXT_TST_TestStatus!=TST_PASS) 
   	goto EXIT; 
   
   EXIT:
																						    
  return EXT_TST_TestStatus;
    
}/* SST_Ext_ATP_ReadOnlyData */



#endif


